/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import io.github.waterfallmc.waterfall.console.WaterfallConsole;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ProxyServer;

public class BungeeCordLauncher {
    public static void main(String[] args) throws Exception {
        Security.setProperty("networkaddress.cache.ttl", "30");
        Security.setProperty("networkaddress.cache.negative.ttl", "10");
        if (System.getProperty("jdk.util.jar.enableMultiRelease") == null) {
            System.setProperty("jdk.util.jar.enableMultiRelease", "force");
        }
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        parser.acceptsAll(Arrays.asList("help"), "Show the help");
        parser.acceptsAll(Arrays.asList("v", "version"), "Print version and exit");
        parser.acceptsAll(Arrays.asList("noconsole"), "Disable console input");
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn(System.out);
            return;
        }
        if (options.has("version")) {
            System.out.println(BungeeCord.class.getPackage().getImplementationVersion());
            return;
        }
        if (BungeeCord.class.getPackage().getSpecificationVersion() != null && System.getProperty("IReallyKnowWhatIAmDoingISwear") == null) {
            Date buildDate = new SimpleDateFormat("yyyyMMdd").parse(BungeeCord.class.getPackage().getSpecificationVersion());
            Calendar deadline = Calendar.getInstance();
            deadline.add(3, -8);
            if (buildDate.before(deadline.getTime())) {
                System.err.println("*** Hey! This build is potentially outdated :( ***");
                System.err.println("*** Please check for a new build from https://papermc.io/downloads ***");
                System.err.println("*** Should this build be outdated, you will get NO support for it. ***");
            }
        }
        BungeeCord bungee = new BungeeCord();
        ProxyServer.setInstance(bungee);
        bungee.getLogger().info("Enabled Waterfall version " + bungee.getVersion());
        bungee.getLogger().warning("Waterfall has reached end of life and is no longer maintained. We recommend you transition to Velocity (https://papermc.io/software/velocity). For more information, see the announcement (https://forums.papermc.io/threads/1088/).");
        bungee.start();
        if (!options.has("noconsole")) {
            new WaterfallConsole().start();
        }
    }
}

