/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.command;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_7_R4.command.ModCustomCommand;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.util.Java15Compat;

public class CraftSimpleCommandMap
extends SimpleCommandMap {
    private static final Pattern PATTERN_ON_SPACE = Pattern.compile(" ", 16);
    private ac vanillaConsoleSender;

    public CraftSimpleCommandMap(Server server) {
        super(server);
    }

    @Override
    public boolean dispatch(CommandSender sender, String commandLine) throws CommandException {
        String[] args;
        if (sender instanceof RemoteConsoleCommandSender) {
            sender = Bukkit.getServer().getConsoleSender();
        }
        if ((args = PATTERN_ON_SPACE.split(commandLine)).length == 0) {
            return false;
        }
        String sentCommandLabel = args[0].toLowerCase();
        Command target = this.getCommand(sentCommandLabel);
        if (target == null) {
            return false;
        }
        try {
            if (target instanceof ModCustomCommand) {
                if (!target.testPermission(sender)) {
                    return true;
                }
                if (sender instanceof ConsoleCommandSender) {
                    FMLCommonHandler.instance().getMinecraftServerInstance().J().a(this.vanillaConsoleSender, commandLine);
                } else if (sender instanceof RemoteConsoleCommandSender) {
                    FMLCommonHandler.instance().getMinecraftServerInstance().J().a((ac)ov.a, commandLine);
                } else {
                    FMLCommonHandler.instance().getMinecraftServerInstance().J().a((ac)((CraftPlayer)sender).getHandle(), commandLine);
                }
            } else {
                target.execute(sender, sentCommandLabel, Java15Compat.Arrays_copyOfRange(args, 1, args.length));
            }
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new CommandException("Unhandled exception executing '" + commandLine + "' in " + target, ex);
        }
        return true;
    }

    public void setVanillaConsoleSender(ac console) {
        this.vanillaConsoleSender = console;
    }
}

