/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util.i18n;

import com.mohistmc.configuration.MohistConfigUtil;
import com.mohistmc.util.i18n.UTF8Control;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class i18n {
    public static ResourceBundle rb = ResourceBundle.getBundle("assets.mohist.lang.message", new UTF8Control());

    public static String get(String key) {
        return rb.getString(key);
    }

    public static String get(String key, Object ... f) {
        return new MessageFormat(i18n.get(key)).format(f);
    }

    public static String getLocale(int key) {
        File f = new File("mohist-config", "mohist.yml");
        String locale = MohistConfigUtil.getString(f, "lang:", "xx");
        if (locale.length() == 5) {
            if (key == 1) {
                return locale.substring(0, 2);
            }
            if (key == 2) {
                return locale.substring(3, 5);
            }
        }
        return "xx";
    }

    public static String getLanguage() {
        return i18n.getLocale(1);
    }

    public static String getCountry() {
        return i18n.getLocale(2);
    }

    public static String getLocale() {
        return rb.getLocale().toString();
    }

    public static boolean isLang(String lang) {
        return i18n.isTimezone("Asia/Shanghai") || i18n.getLocale().contains(lang) || i18n.getCountry().contains(lang);
    }

    public static boolean isTimezone(String timezone) {
        TimeZone timeZone = TimeZone.getDefault();
        return timeZone.getID().equals(timezone);
    }
}

