/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.command;

import com.mohistmc.api.ServerAPI;
import com.mohistmc.util.i18n.i18n;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.bukkit.ChatColor;
import org.bukkit.block.Biome;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class DumpCommand
extends Command {
    private List<String> params = Arrays.asList("potions", "enchants", "cbcmds", "modscmds", "entitytypes", "biomes");

    public DumpCommand(String name) {
        super(name);
        this.description = "Universal Dump, which will print the information you need locally!";
        this.usageMessage = "/dump [potions|enchants|cbcmds|modscmds|entitytypes|biomes]";
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 && sender.isOp()) {
            for (String param : this.params) {
                if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(param);
            }
        }
        return list;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!sender.isOp()) {
            sender.sendMessage(i18n.get("command.nopermission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        if ("potions".equals(args[0].toLowerCase(Locale.ENGLISH))) {
            DumpCommand.dumpPotions(sender);
        } else if ("enchants".equals(args[0].toLowerCase(Locale.ENGLISH))) {
            this.dumpEnchant(sender);
        } else if ("cbcmds".equals(args[0].toLowerCase(Locale.ENGLISH))) {
            this.dumpCBCommands(sender);
        } else if ("modscmds".equals(args[0].toLowerCase(Locale.ENGLISH))) {
            this.dumpModsCommands(sender);
        } else if ("entitytypes".equals(args[0].toLowerCase(Locale.ENGLISH))) {
            this.dumpEntityTypes(sender);
        } else if ("biomes".equals(args[0].toLowerCase(Locale.ENGLISH))) {
            this.dumpBiomes(sender);
        } else {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        return false;
    }

    public static void dumpPotions(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (PotionEffectType potionEffectType : PotionEffectType.values()) {
            if (potionEffectType == null) continue;
            sb.append(potionEffectType.toString()).append("\n");
        }
        for (PotionType potionType : PotionType.values()) {
            if (potionType == null) continue;
            sb.append(potionType.toString()).append("\n");
        }
        try {
            FileUtils.writeByteArrayToFile((File)new File("dump", "potions.mo"), (byte[])sb.toString().getBytes(Charsets.UTF_8));
            sender.sendMessage("Ok");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void dumpEnchant(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (Enchantment ench : Enchantment.values()) {
            sb.append(ench.toString()).append("\n");
        }
        try {
            FileUtils.writeByteArrayToFile((File)new File("dump", "enchant.mo"), (byte[])sb.toString().getBytes(Charsets.UTF_8));
            sender.sendMessage("Ok");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void dumpEntityTypes(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (EntityType ent : EntityType.values()) {
            sb.append(ent.toString()).append("\n");
        }
        try {
            FileUtils.writeByteArrayToFile((File)new File("dump", "entitytypes.mo"), (byte[])sb.toString().getBytes(Charsets.UTF_8));
            sender.sendMessage("Ok");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void dumpCBCommands(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (Command per : MinecraftServer.I().server.getCommandMap().getCommands()) {
            if (per.getPermission() == null) continue;
            sb.append(per.getName()).append(": ").append(per.getPermission()).append("\n");
        }
        try {
            FileUtils.writeByteArrayToFile((File)new File("dump", "cbcommands.mo"), (byte[])sb.toString().getBytes(Charsets.UTF_8));
            sender.sendMessage("Ok");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void dumpModsCommands(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> m : ServerAPI.forgecmdper.entrySet()) {
            sb.append(m.getKey()).append(": ").append(m.getValue()).append("\n");
        }
        try {
            FileUtils.writeByteArrayToFile((File)new File("dump", "modscommands.mo"), (byte[])sb.toString().getBytes(Charsets.UTF_8));
            sender.sendMessage("Ok");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void dumpBiomes(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (Biome biome : Biome.values()) {
            sb.append(biome.toString()).append("\n");
        }
        try {
            FileUtils.writeByteArrayToFile((File)new File("dump", "biomes.mo"), (byte[])sb.toString().getBytes(Charsets.UTF_8));
            sender.sendMessage("Ok");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

