/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;

public class StringSubstitutor {
    private static final Map<String, String> globals = ImmutableMap.of((Object)"mcVersion", (Object)FMLLoader.mcVersion, (Object)"forgeVersion", (Object)FMLLoader.forgeVersion);

    public static String replace(String in, ModFile file) {
        return new StrSubstitutor(StringSubstitutor.getStringLookup(file)).replace(in);
    }

    private static StrLookup<String> getStringLookup(final ModFile file) {
        return new StrLookup<String>(){

            public String lookup(String key) {
                String[] parts = key.split("\\.");
                if (parts.length == 1) {
                    return key;
                }
                String pfx = parts[0];
                if ("global".equals(pfx)) {
                    return globals.get(parts[1]);
                }
                if ("file".equals(pfx) && file != null) {
                    return String.valueOf(file.getSubstitutionMap().get().get(parts[1]));
                }
                return key;
            }
        };
    }
}

