/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.ITransformingClassLoader;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLCommonLaunchHandler;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LibraryFinder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FMLServerLaunchProvider
extends FMLCommonLaunchHandler
implements ILaunchHandlerService {
    private static final Logger LOGGER = LogManager.getLogger();

    public String name() {
        return "fmlserver";
    }

    public Callable<Void> launchService(String[] arguments, ITransformingClassLoader launchClassLoader) {
        return () -> {
            super.beforeStart(launchClassLoader);
            launchClassLoader.addTargetPackageFilter(this.getPackagePredicate());
            Class.forName("net.minecraft.server.Main", true, launchClassLoader.getInstance()).getMethod("main", String[].class).invoke(null, new Object[]{arguments});
            return null;
        };
    }

    @Override
    public void setup(IEnvironment environment, Map<String, ?> arguments) {
        ArrayList<String> mavenRoots = new ArrayList<String>((List)arguments.get("mavenRoots"));
        ArrayList<CallSite> mods = new ArrayList<CallSite>((List)arguments.get("mods"));
        mavenRoots.add(LibraryFinder.findLibsPath().toString());
        String forgeVersion = (String)arguments.get("mohistVersion");
        String mcVersion = (String)arguments.get("mcVersion");
        String forgeGroup = (String)arguments.get("forgeGroup");
        mods.add((CallSite)((Object)(forgeGroup + ":mohist:universal:" + mcVersion + "-" + forgeVersion)));
        arguments.put("mavenRoots", mavenRoots);
        arguments.put("mods", mods);
    }

    @Override
    public Dist getDist() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    protected String getNaming() {
        return "srg";
    }

    public Path[] getPaths() {
        return FMLLoader.getMCPaths();
    }

    @Override
    public boolean isProduction() {
        return true;
    }
}

