/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.config.MohistConfigUtil;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public enum DownloadSource {
    MOHIST("https://maven.mohistmc.com/"),
    GITHUB("https://mohistmc.github.io/maven/");

    final String url;

    private DownloadSource(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public static DownloadSource get() {
        String ds = MohistConfigUtil.sMohist("mohist.libraries_downloadsource", MOHIST.name());
        for (DownloadSource me : DownloadSource.values()) {
            if (!me.name().equalsIgnoreCase(ds)) continue;
            if (DownloadSource.isDown(me.url.replace("releases/", "")) != 200) {
                return GITHUB;
            }
            return me;
        }
        return MOHIST;
    }

    public static int isDown(String s) {
        try {
            URL url = new URL(s);
            URLConnection rulConnection = url.openConnection();
            HttpURLConnection httpUrlConnection = (HttpURLConnection)rulConnection;
            httpUrlConnection.connect();
            return httpUrlConnection.getResponseCode();
        }
        catch (Exception e) {
            return 0;
        }
    }
}

