/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.bukkit.nms.utils.srgutils;

import com.mohistmc.bukkit.nms.utils.srgutils.IMappingFile;
import com.mohistmc.bukkit.nms.utils.srgutils.MappingFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class InternalUtils {
    private static final List<String> ORDER = Arrays.asList("PK:", "CL:", "FD:", "MD:");

    InternalUtils() {
    }

    static IMappingFile load(InputStream in2) throws IOException {
        List lines = new BufferedReader(new InputStreamReader(in2, StandardCharsets.UTF_8)).lines().map(InternalUtils::stripComment).filter(l2 -> !l2.isEmpty()).collect(Collectors.toList());
        MappingFile ret = new MappingFile();
        String firstLine = (String)lines.get(0);
        String test = firstLine.split(" ")[0];
        if ("PK:".equals(test) || "CL:".equals(test) || "FD:".equals(test) || "MD:".equals(test)) {
            block12: for (String line : lines) {
                String[] pts2 = line.split(" ");
                switch (pts2[0]) {
                    case "PK:": {
                        ret.addPackage(pts2[1], pts2[2]);
                        continue block12;
                    }
                    case "CL:": {
                        ret.addClass(pts2[1], pts2[2]);
                        continue block12;
                    }
                    case "FD:": {
                        if (pts2.length == 5) {
                            ret.getOrCreateClass(InternalUtils.rsplit(pts2[1], '/', 1)[0]).addField(InternalUtils.rsplit(pts2[1], '/', 1)[1], InternalUtils.rsplit(pts2[3], '/', 1)[1], pts2[2]);
                            continue block12;
                        }
                        ret.getOrCreateClass(InternalUtils.rsplit(pts2[1], '/', 1)[0]).addField(InternalUtils.rsplit(pts2[1], '/', 1)[1], InternalUtils.rsplit(pts2[2], '/', 1)[1]);
                        continue block12;
                    }
                    case "MD:": {
                        ret.getOrCreateClass(InternalUtils.rsplit(pts2[1], '/', 1)[0]).addMethod(InternalUtils.rsplit(pts2[1], '/', 1)[1], pts2[2], InternalUtils.rsplit(pts2[3], '/', 1)[1]);
                        continue block12;
                    }
                }
                throw new IOException("Invalid SRG file, Unknown type: " + line);
            }
        } else if (firstLine.contains(" -> ")) {
            for (String line : lines) {
                if (line.startsWith("    ") || !line.endsWith(":")) continue;
                String[] pts3 = line.replace('.', '/').split(" -> ");
                ret.addClass(pts3[0], pts3[1].substring(0, pts3[1].length() - 1));
            }
            MappingFile.Cls cls = null;
            for (String line : lines) {
                if (!(line = line.replace('.', '/')).startsWith("    ") && line.endsWith(":")) {
                    cls = ret.getClass(line.split(" -> ")[0]);
                    continue;
                }
                if (line.contains("(") && line.contains(")")) {
                    if (cls == null) {
                        throw new IOException("Invalid PG line, missing class: " + line);
                    }
                    line = line.trim();
                    int start = 0;
                    int end = 0;
                    if (line.indexOf(58) != -1) {
                        int i2 = line.indexOf(58);
                        int j = line.indexOf(58, i2 + 1);
                        start = Integer.parseInt(line.substring(0, i2));
                        end = Integer.parseInt(line.substring(i2 + 1, j));
                        line = line.substring(j + 1);
                    }
                    String obf = line.split(" -> ")[1];
                    String _ret = InternalUtils.toDesc(line.split(" ")[0]);
                    String name = line.substring(line.indexOf(32) + 1, line.indexOf(40));
                    String[] args = line.substring(line.indexOf(40) + 1, line.indexOf(41)).split(",");
                    StringBuilder desc = new StringBuilder();
                    desc.append('(');
                    for (String arg : args) {
                        if (arg.isEmpty()) break;
                        desc.append(InternalUtils.toDesc(arg));
                    }
                    desc.append(')').append(_ret);
                    cls.addMethod(name, desc.toString(), obf, start, end);
                    continue;
                }
                if (cls == null) {
                    throw new IOException("Invalid PG line, missing class: " + line);
                }
                String[] pts4 = line.trim().split(" ");
                cls.addField(pts4[1], pts4[3], InternalUtils.toDesc(pts4[0]));
            }
        } else {
            lines.stream().filter(l2 -> l2.charAt(0) != '\t').map(l2 -> l2.split(" ")).filter(pts -> ((String[])pts).length == 2).forEach(pts -> {
                if (pts[0].endsWith("/")) {
                    ret.addPackage(pts[0].substring(0, pts[0].length() - 1), pts[1].substring(0, pts[1].length() - 1));
                } else {
                    ret.addClass(pts[0], pts[1]);
                }
            });
            MappingFile.Cls cls = null;
            for (String line : lines) {
                String[] pts5 = line.split(" ");
                if (pts5[0].charAt(0) == '\t') {
                    if (cls == null) {
                        throw new IOException("Invalid TSRG line, missing class: " + line);
                    }
                    pts5[0] = pts5[0].substring(1);
                    if (pts5.length == 2) {
                        cls.addField(pts5[0], pts5[1]);
                        continue;
                    }
                    if (pts5.length == 3) {
                        cls.addMethod(pts5[0], pts5[1], pts5[2]);
                        continue;
                    }
                    throw new IOException("Invalid TSRG line, to many parts: " + line);
                }
                if (pts5.length == 2) {
                    if (pts5[0].endsWith("/")) continue;
                    cls = ret.getClass(pts5[0]);
                    continue;
                }
                if (pts5.length == 3) {
                    ret.getClass(pts5[0]).addField(pts5[1], pts5[2]);
                    continue;
                }
                if (pts5.length == 4) {
                    ret.getClass(pts5[0]).addMethod(pts5[1], pts5[2], pts5[3]);
                    continue;
                }
                throw new IOException("Invalid CSRG line, to many parts: " + line);
            }
        }
        return ret;
    }

    static String toDesc(String type) {
        if (type.endsWith("[]")) {
            return "[" + InternalUtils.toDesc(type.substring(0, type.length() - 2));
        }
        if (type.equals("int")) {
            return "I";
        }
        if (type.equals("void")) {
            return "V";
        }
        if (type.equals("boolean")) {
            return "Z";
        }
        if (type.equals("byte")) {
            return "B";
        }
        if (type.equals("char")) {
            return "C";
        }
        if (type.equals("short")) {
            return "S";
        }
        if (type.equals("double")) {
            return "D";
        }
        if (type.equals("float")) {
            return "F";
        }
        if (type.equals("long")) {
            return "J";
        }
        if (type.contains("/")) {
            return "L" + type + ";";
        }
        throw new RuntimeException("Invalid toDesc input: " + type);
    }

    static String toSource(String desc) {
        char first = desc.charAt(0);
        switch (first) {
            case 'I': {
                return "int";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'S': {
                return "short";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "long";
            }
            case '[': {
                return InternalUtils.toSource(desc.substring(1)) + "[]";
            }
            case 'L': {
                return desc.substring(1, desc.length() - 1).replace('/', '.');
            }
        }
        throw new IllegalArgumentException("Unknown descriptor: " + desc);
    }

    static String toSource(String name, String desc) {
        StringBuilder buf = new StringBuilder();
        int endParams = desc.lastIndexOf(41);
        String ret = desc.substring(endParams + 1);
        buf.append(InternalUtils.toSource(ret)).append(' ').append(name).append('(');
        int idx = 1;
        while (idx < endParams) {
            int array = 0;
            char c2 = desc.charAt(idx);
            if (c2 == '[') {
                while (desc.charAt(idx) == '[') {
                    ++array;
                    ++idx;
                }
                c2 = desc.charAt(idx);
            }
            if (c2 == 'L') {
                int end = desc.indexOf(59, idx);
                buf.append(InternalUtils.toSource(desc.substring(idx, end + 1)));
                idx = end;
            } else {
                buf.append(InternalUtils.toSource(c2 + ""));
            }
            while (array-- > 0) {
                buf.append("[]");
            }
            if (++idx >= endParams) continue;
            buf.append(',');
        }
        buf.append(')');
        return buf.toString();
    }

    private static String[] rsplit(String str, char chr, int count) {
        int idx;
        ArrayList<String> pts = new ArrayList<String>();
        while ((idx = str.lastIndexOf(chr)) != -1 && count > 0) {
            pts.add(str.substring(idx + 1));
            str = str.substring(0, idx);
            --count;
        }
        pts.add(str);
        Collections.reverse(pts);
        return pts.toArray(new String[0]);
    }

    public static int compareLines(String o1, String o2) {
        String[] pt2;
        String[] pt1 = o1.split(" ");
        if (!pt1[0].equals((pt2 = o2.split(" "))[0])) {
            return ORDER.indexOf(pt1[0]) - ORDER.lastIndexOf(pt2[0]);
        }
        if ("PK:".equals(pt1[0])) {
            return o1.compareTo(o2);
        }
        if ("CL:".equals(pt1[0])) {
            return InternalUtils.compareCls(pt1[1], pt2[1]);
        }
        if ("FD:".equals(pt1[0]) || "MD:".equals(pt1[0])) {
            String[][] y = new String[][]{{pt1[1].substring(0, pt1[1].lastIndexOf(47)), pt1[1].substring(pt1[1].lastIndexOf(47) + 1)}, {pt2[1].substring(0, pt2[1].lastIndexOf(47)), pt2[1].substring(pt2[1].lastIndexOf(47) + 1)}};
            int ret = InternalUtils.compareCls(y[0][0], y[1][0]);
            if (ret != 0) {
                return ret;
            }
            return y[0][1].compareTo(y[1][1]);
        }
        return o1.compareTo(o2);
    }

    public static int compareCls(String cls1, String cls2) {
        if (cls1.indexOf(47) > 0 && cls2.indexOf(47) > 0) {
            return cls1.compareTo(cls2);
        }
        String[][] t = new String[][]{cls1.split("\\$"), cls2.split("\\$")};
        int max = Math.min(t[0].length, t[1].length);
        for (int i2 = 0; i2 < max; ++i2) {
            if (t[0][i2].equals(t[1][i2])) continue;
            if (t[0][i2].length() != t[1][i2].length()) {
                return t[0][i2].length() - t[1][i2].length();
            }
            return t[0][i2].compareTo(t[1][i2]);
        }
        return Integer.compare(t[0].length, t[1].length);
    }

    public static String stripComment(String str) {
        int end;
        int idx = str.indexOf(35);
        if (idx == 0) {
            return "";
        }
        if (idx != -1) {
            str = str.substring(0, idx - 1);
        }
        for (end = str.length(); end > 1 && str.charAt(end - 1) == ' '; --end) {
        }
        return end == 0 ? "" : str.substring(0, end);
    }
}

