/*
 * Decompiled with CFR 0.152.
 */
package cn.dreeam.leaper;

import cn.dreeam.leaper.Util;
import cn.dreeam.leaper.libs.io.sigpipe.jbsdiff.InvalidHeaderException;
import cn.dreeam.leaper.libs.io.sigpipe.jbsdiff.Patch;
import cn.dreeam.leaper.libs.org.apache.commons.compress.compressors.CompressorException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;

record PatchEntry(String location, byte[] originalHash, byte[] patchHash, byte[] outputHash, String originalPath, String patchPath, String outputPath) {
    private static boolean announced = false;

    static PatchEntry[] parse(BufferedReader reader) throws IOException {
        String line;
        PatchEntry[] result = new PatchEntry[8];
        int index = 0;
        while ((line = reader.readLine()) != null) {
            PatchEntry data = PatchEntry.parseLine(line);
            if (data == null) continue;
            if (index == result.length) {
                result = Arrays.copyOf(result, index * 2);
            }
            result[index++] = data;
        }
        if (index != result.length) {
            return Arrays.copyOf(result, index);
        }
        return result;
    }

    private static PatchEntry parseLine(String line) {
        if (line.isBlank()) {
            return null;
        }
        if (line.startsWith("#")) {
            return null;
        }
        String[] parts = line.split("\t");
        if (parts.length != 7) {
            throw new IllegalStateException("Invalid patch data line: " + line);
        }
        return new PatchEntry(parts[0], Util.fromHex(parts[1]), Util.fromHex(parts[2]), Util.fromHex(parts[3]), parts[4], parts[5], parts[6]);
    }

    void applyPatch(Map<String, Map<String, URL>> urls, Path originalRootDir, Path repoDir) throws IOException {
        Path inputDir = originalRootDir.resolve("META-INF").resolve(this.location);
        Path targetDir = repoDir.resolve(this.location);
        Path inputFile = inputDir.resolve(this.originalPath);
        Path outputFile = targetDir.resolve(this.outputPath);
        if (Files.exists(outputFile, new LinkOption[0]) && Util.isFileValid(outputFile, this.outputHash)) {
            urls.get(this.location).put(this.originalPath, outputFile.toUri().toURL());
            return;
        }
        if (!announced) {
            System.out.println("Applying patches");
            announced = true;
        }
        if (Files.notExists(inputFile, new LinkOption[0])) {
            throw new IllegalStateException("Input file not found: " + inputFile);
        }
        if (!Util.isFileValid(inputFile, this.originalHash)) {
            throw new IllegalStateException("Hash check of input file failed for " + inputFile);
        }
        String fullPatchPath = "/META-INF/" + Util.endingSlash(this.location) + this.patchPath;
        InputStream patchStream = PatchEntry.class.getResourceAsStream(fullPatchPath);
        if (patchStream == null) {
            throw new IllegalStateException("Patch file not found: " + fullPatchPath);
        }
        byte[] patchBytes = Util.readFully(patchStream);
        if (!Util.isDataValid(patchBytes, this.patchHash)) {
            throw new IllegalStateException("Hash check of patch file failed for " + fullPatchPath);
        }
        byte[] originalBytes = Util.readBytes(inputFile);
        try {
            if (!Files.isDirectory(outputFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            }
            try (BufferedOutputStream outStream = new BufferedOutputStream(Files.newOutputStream(outputFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));){
                Patch.patch(originalBytes, patchBytes, outStream);
            }
        }
        catch (InvalidHeaderException | CompressorException | IOException e) {
            throw Util.fail("Failed to patch " + inputFile, e);
        }
        if (!Util.isFileValid(outputFile, this.outputHash)) {
            throw new IllegalStateException("Patch not applied correctly for " + this.outputPath);
        }
        urls.get(this.location).put(this.originalPath, outputFile.toUri().toURL());
    }
}

