/*
 * Decompiled with CFR 0.152.
 */
package cn.dreeam.leaper;

import cn.dreeam.leaper.PatchEntry;
import cn.dreeam.leaper.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;

record FileEntry(byte[] hash, String id, String path) {
    static FileEntry[] parse(BufferedReader reader) throws IOException {
        String line;
        FileEntry[] result = new FileEntry[8];
        int index = 0;
        while ((line = reader.readLine()) != null) {
            FileEntry data = FileEntry.parseLine(line);
            if (index == result.length) {
                result = Arrays.copyOf(result, index * 2);
            }
            result[index++] = data;
        }
        if (index != result.length) {
            return Arrays.copyOf(result, index);
        }
        return result;
    }

    private static FileEntry parseLine(String line) {
        String[] parts = line.split("\t");
        if (parts.length != 3) {
            throw new IllegalStateException("Malformed library entry: " + line);
        }
        return new FileEntry(Util.fromHex(parts[0]), parts[1], parts[2]);
    }

    void extractFile(Map<String, URL> urls, PatchEntry[] patches, String targetName, Path originalRootDir, String baseDir, Path outputDir) throws IOException {
        for (PatchEntry patch : patches) {
            if (!patch.location().equals(targetName) || !patch.outputPath().equals(this.path)) continue;
            return;
        }
        Path outputFile = outputDir.resolve(this.path);
        if (Files.exists(outputFile, new LinkOption[0]) && Util.isFileValid(outputFile, this.hash)) {
            urls.put(this.path, outputFile.toUri().toURL());
            return;
        }
        String filePath = Util.endingSlash(baseDir) + this.path;
        InputStream fileStream = FileEntry.class.getResourceAsStream(filePath);
        if (fileStream == null) {
            if (originalRootDir == null) {
                throw new IllegalStateException(this.path + " not found in our jar, and no original jar provided");
            }
            Path originalFile = originalRootDir.resolve(filePath);
            if (Files.notExists(originalFile, new LinkOption[0])) {
                throw new IllegalStateException(this.path + " not found in our jar or in the original jar");
            }
            fileStream = Files.newInputStream(originalFile, new OpenOption[0]);
        }
        if (!Files.isDirectory(outputFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        }
        Files.deleteIfExists(outputFile);
        try (InputStream stream = fileStream;
             ReadableByteChannel inputChannel = Channels.newChannel(stream);
             FileChannel outputChannel = FileChannel.open(outputFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            outputChannel.transferFrom(inputChannel, 0L, Long.MAX_VALUE);
        }
        if (!Util.isFileValid(outputFile, this.hash)) {
            throw new IllegalStateException("Hash check failed for extract filed " + outputFile);
        }
        urls.put(this.path, outputFile.toUri().toURL());
    }
}

