/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.actions.Action;
import net.minecraftforge.installer.actions.ActionCanceledException;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Util;

public class ServerInstall
extends Action {
    private List<Artifact> grabbed = new ArrayList<Artifact>();

    public ServerInstall(InstallV1 profile, ProgressCallback monitor) {
        super(profile, monitor, false);
    }

    @Override
    public boolean run(File target, File installer) throws ActionCanceledException {
        if (target.exists() && !target.isDirectory()) {
            this.error("There is a file at this location, the server cannot be installed here!");
            return false;
        }
        File librariesDir = new File(target, "libraries");
        if (!target.exists()) {
            target.mkdirs();
        }
        librariesDir.mkdir();
        this.checkCancel();
        Artifact contained = this.profile.getPath();
        if (contained != null) {
            this.monitor.stage("Extracting main jar:");
            if (!DownloadUtils.extractFile(contained, new File(target, contained.getFilename()), null)) {
                this.error("  Failed to extract main jar: " + contained.getFilename());
                return false;
            }
            this.monitor.stage("  Extracted successfully");
        }
        this.checkCancel();
        this.monitor.stage("Considering minecraft server jar");
        HashMap<String, Supplier<String>> tokens = new HashMap<String, Supplier<String>>();
        tokens.put("ROOT", target::getAbsolutePath);
        tokens.put("MINECRAFT_VERSION", this.profile::getMinecraft);
        tokens.put("LIBRARY_DIR", librariesDir::getAbsolutePath);
        String path = Util.replaceTokens(tokens, this.profile.getServerJarPath());
        File serverTarget = new File(path);
        if (!this.downloadVanilla(serverTarget, "server")) {
            return false;
        }
        this.checkCancel();
        ArrayList<File> libDirs = new ArrayList<File>();
        File mcLibDir = new File(SimpleInstaller.getMCDir(), "libraries");
        if (mcLibDir.exists()) {
            libDirs.add(mcLibDir);
        }
        if (!this.downloadLibraries(librariesDir, libDirs)) {
            return false;
        }
        this.checkCancel();
        return this.processors.process(librariesDir, serverTarget, target, installer) != null;
    }

    @Override
    public boolean isPathValid(File targetDir) {
        return targetDir.exists() && targetDir.isDirectory() && targetDir.list().length == 0;
    }

    @Override
    public String getFileError(File targetDir) {
        if (!targetDir.exists()) {
            return "The specified directory does not exist<br/>It will be created";
        }
        if (!targetDir.isDirectory()) {
            return "The specified path needs to be a directory";
        }
        return "There are already files at the target directory";
    }

    @Override
    public String getSuccessMessage() {
        if (this.grabbed.size() > 0) {
            return String.format("Successfully downloaded minecraft server, downloaded %d libraries and installed %s", this.grabbed.size(), this.profile.getVersion());
        }
        return String.format("Successfully downloaded minecraft server and installed %s", this.profile.getVersion());
    }
}

